$Title: (7) Split land value added (VFM, EVFA, EVOA) by rb-aez              

*       ----------------------------------------------------------------       *
*                                                                              *
*                       Global Trade Analysis Project                          *
*                            GTAP Water database                               *
*         (7)  Split land value added (VFM, EVFA, EVOA) by rb-aez              *
*                                                                              *
*       ----------------------------------------------------------------       *



*-------  define taxes using vfm and evfa ---
Parameters
  residual
  rTFi
  rTFr
;

rTFi(a,b,c,r) = 1;
rTFr(a,b,c,r) = 1;
rTF(a,b,nc,r) = 1;

rTFi(a,b,c,r)$sum(ic,vfm('land',ic,r)$map_crop(ic,c))=
         sum(ic,evfa('land',ic,r)$map_crop(ic,c)) / sum(ic,vfm('land',ic,r)$map_crop(ic,c));

rTFr(a,b,c,r)$sum(rc,vfm('land',rc,r)$map_crop(rc,c))=
         sum(rc,evfa('land',rc,r)$map_crop(rc,c)) / sum(rc,vfm('land',rc,r)$map_crop(rc,c));

rTF(a,b,nc,r)$vfm('land',nc,r) = evfa('land',nc,r)/vfm('land',nc,r);


*------- (3) split land value added to rb-aez ---
parameters
  VFM_     Temp VFM header for land and water by RBAEZ
  EVFA_    Temp EVFA header for land and water by RBAEZ
  EVOA_    Temp EVOA header for land and water by RBAEZ;

 vfm_('IrrWL',a,b,c,r)
         = shr_irr(r,a,b,c)*sum(ic,  vfm('land',ic,r)$map_crop(ic,c)) ;
 vfm_('OthLand',a,b,NONCROP,r)
         = shr_pstr(r,a,b)* vfm('land',NONCROP,r) ;
 vfm_('OthLand',a,b,'frs',r)
         = shr_frst(r,a,b)* vfm('land','frs',r) ;
 vfm_('RfdLand',a,b,c,r)
         = shr_rfd(r,a,b,c)*sum(rc,  vfm('land',rc,r)$map_crop(rc,c)) ;

evfa_('IrrWL',a,b,c,r)
         = rTFi(a,b,c,r) * vfm_('IrrWL',a,b,c,r);
evfa_('OthLand',a,b,NONCROP,r)
         = rTF(a,b,NONCROP,r) * vfm_('OthLand',a,b,NONCROP,r);
evfa_('OthLand',a,b,'frs',r)
         = rTF(a,b,'frs',r) * vfm_('OthLand',a,b,'frs',r);
evfa_('RfdLand',a,b,c,r)
         = rTFr(a,b,c,r) * vfm_('RfdLand',a,b,c,r);

*evfa_('IrrWL',a,b,c,r) = shr_irr(r,a,b,c)*sum(ic, evfa('land',ic,r)$map_crop(ic,c)) ;
*evfa_('OthLand',a,b,'frs',r) = shr_frst(r,a,b)*evfa('land','frs',r) ;
*evfa_('OthLand',a,b,NONCROP,r) = shr_pstr(r,a,b)*evfa('land',NONCROP,r) ;
*evfa_('RfdLand',a,b,c,r) = shr_rfd(r,a,b,c)*sum(rc, evfa('land',rc,r)$map_crop(rc,c)) ;

taxevoa('land',r)$(sum(g, vfm('land',g,r) gt eps))
 = evoa('land',r)/ sum(g, vfm('land',g,r));

evoa_('IrrWL',a,b,r) =
     taxevoa('land',r)*sum(g, vfm_('IrrWL',a,b,g,r) );

evoa_('OthLand',a,b,r) =
     taxevoa('land',r)*sum(g, vfm_('OthLand',a,b,g,r) );

evoa_('RfdLand',a,b,r) =
     taxevoa('land',r)*sum(g, vfm_('RfdLand',a,b,g,r) );
